/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.Stack;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ActionListHandler
extends DefaultHandler {
    private String path;
    private JEditActionSet actionSet;
    private String actionName;
    private final StringBuilder code;
    private final StringBuilder isSelected;
    private boolean noRepeat;
    private boolean noRecord;
    private boolean noRememberLast;
    private final Stack<String> stateStack;

    ActionListHandler(String string, JEditActionSet jEditActionSet) {
        this.path = string;
        this.actionSet = jEditActionSet;
        this.stateStack = new Stack();
        this.code = new StringBuilder();
        this.isSelected = new StringBuilder();
    }

    public InputSource resolveEntity(String string, String string2) {
        return XMLUtilities.findEntity(string2, "actions.dtd", this.getClass());
    }

    public void attribute(String string, String string2, boolean bl) {
        string = string == null ? null : string.intern();
        String string3 = string2 = string2 == null ? null : string2.intern();
        if (string == "NAME") {
            this.actionName = string2;
        } else if (string == "NO_REPEAT") {
            this.noRepeat = string2 == "TRUE";
        } else if (string == "NO_RECORD") {
            this.noRecord = string2 == "TRUE";
        } else if (string == "NO_REMEMBER_LAST") {
            this.noRememberLast = string2 == "TRUE";
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        if (string.equals("CODE")) {
            this.code.append(cArray, n, n2);
        } else if (string.equals("IS_SELECTED")) {
            this.isSelected.append(cArray, n, n2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4 = this.pushElement(string3);
        if (string4.equals("ACTION")) {
            this.actionName = attributes.getValue("NAME");
            this.noRepeat = "TRUE".equals(attributes.getValue("NO_REPEAT"));
            this.noRecord = "TRUE".equals(attributes.getValue("NO_RECORD"));
            this.noRememberLast = "TRUE".equals(attributes.getValue("NO_REMEMBER_LAST"));
            this.code.setLength(0);
            this.isSelected.setLength(0);
        }
    }

    public void endElement(String string, String string2, String string3) {
        String string4 = this.peekElement();
        if (string3.equals(string4)) {
            if (string4.equals("ACTION")) {
                String string5 = this.isSelected.length() > 0 ? this.isSelected.toString() : null;
                JEditAbstractEditAction jEditAbstractEditAction = this.actionSet.createBeanShellAction(this.actionName, this.code.toString(), string5, this.noRepeat, this.noRecord, this.noRememberLast);
                this.actionSet.addAction(jEditAbstractEditAction);
                this.noRememberLast = false;
                this.noRecord = false;
                this.noRepeat = false;
                this.code.setLength(0);
                this.isSelected.setLength(0);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    private String pushElement(String string) {
        string = string == null ? null : string.intern();
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

