/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import buffertabs.BufferTabComponent;
import buffertabs.BufferTabsPlugin;
import buffertabs.ColorTabs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.Log;

public class BufferTabs
extends JTabbedPane
implements EBComponent,
BufferSetListener {
    private static final String SORT_BUFFERS = "sortBuffers";
    private final EditPane editPane;
    private final JComponent textArea;
    BufferSet bufferSet;
    private final ChangeHandler changeHandler;
    private final MouseHandler mouseHandler;
    private final MouseMotionHandler mouseMotionHandler;
    private final Set<Buffer> knownBuffers;
    private static int moving = -1;

    public BufferTabs(EditPane editPane) {
        this.editPane = editPane;
        this.textArea = editPane.getTextArea();
        this.changeHandler = new ChangeHandler();
        this.changeHandler.setEnabled(true);
        this.mouseHandler = new MouseHandler();
        this.mouseMotionHandler = new MouseMotionHandler();
        this.knownBuffers = Collections.synchronizedSet(new HashSet());
    }

    public synchronized void start() {
        this.propertiesChanged();
        BufferSet bufferSet = this.editPane.getBufferSet();
        this.setBufferSet(bufferSet);
        EditBus.addToBus((EBComponent)this);
        int index = bufferSet.indexOf(this.editPane.getBuffer());
        this.updateColorAt(this.getSelectedIndex());
        if (index >= 0) {
            this.setSelectedIndex(index);
            this.updateHighlightAt(index);
        }
        this.addChangeListener(this.changeHandler);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseMotionHandler);
    }

    public synchronized void stop() {
        EditBus.removeFromBus((EBComponent)this);
        this.removeChangeListener(this.changeHandler);
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseMotionHandler);
    }

    private static boolean areBuffersSorted() {
        return jEdit.getBooleanProperty((String)SORT_BUFFERS);
    }

    private static void stopBufferSorting() {
        jEdit.setBooleanProperty((String)SORT_BUFFERS, (boolean)false);
        jEdit.propertiesChanged();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(EBMessage message) {
        EditPaneUpdate epu;
        EditPane editPane;
        if (message instanceof BufferUpdate) {
            Buffer buff;
            int index;
            BufferUpdate bu = (BufferUpdate)message;
            Buffer buffer = bu.getBuffer();
            if (bu.getWhat() == BufferUpdate.DIRTY_CHANGED || bu.getWhat() == BufferUpdate.CREATED) {
                int index2 = this.bufferSet.indexOf(buffer);
                if (index2 >= 0 && index2 < this.getTabCount()) {
                    this.updateTitleAt(index2);
                }
            } else if (bu.getWhat() == BufferUpdate.LOADED) {
                int index3 = this.bufferSet.indexOf(buffer);
                if (index3 >= 0 && index3 < this.getTabCount()) {
                    this.updateTitleAt(index3);
                    this.updateHighlightAt(index3);
                }
            } else if (bu.getWhat() == BufferUpdate.SAVED && (index = this.bufferSet.indexOf(buff = bu.getBuffer())) >= 0 && index < this.getTabCount()) {
                this.setToolTipTextAt(index, buff.getPath());
            }
        } else if (message instanceof EditPaneUpdate && (editPane = (epu = (EditPaneUpdate)message).getEditPane()) == this.editPane) {
            if (epu.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
                try {
                    Buffer buffer = editPane.getBuffer();
                    int index = this.bufferSet.indexOf(buffer);
                    if (!this.knownBuffers.contains(buffer) && index != -1) {
                        this.bufferAdded(buffer, index);
                    }
                    this.changeHandler.setEnabled(false);
                    this.updateColorAt(this.getSelectedIndex());
                    this.setSelectedIndex(index);
                    this.updateHighlightAt(index);
                }
                finally {
                    this.changeHandler.setEnabled(true);
                }
            } else if (epu.getWhat() == EditPaneUpdate.BUFFERSET_CHANGED) {
                this.setBufferSet(editPane.getBufferSet());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferRemoved(Buffer buffer, int index) {
        try {
            this.changeHandler.setEnabled(false);
            this.knownBuffers.remove(buffer);
            this.removeTabAt(index);
            if (this.getTabCount() > 0 && super.indexOfComponent(this.textArea) == -1) {
                this.setComponentAt(0, this.textArea);
                this.textArea.setVisible(true);
            }
        }
        finally {
            this.changeHandler.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferMoved(Buffer buffer, int oldIndex, int newIndex) {
        try {
            this.changeHandler.setEnabled(false);
            this.bufferRemoved(buffer, oldIndex);
            this.bufferAdded(buffer, newIndex);
        }
        finally {
            this.changeHandler.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferAdded(Buffer buffer, int index) {
        if (this.knownBuffers.contains(buffer)) {
            return;
        }
        try {
            this.changeHandler.setEnabled(false);
            this.knownBuffers.add(buffer);
            JComponent component = null;
            if (super.indexOfComponent(this.textArea) == -1) {
                component = this.textArea;
            }
            this.insertTab(buffer.getName(), null, component, buffer.getPath(), index);
            this.updateTitleAt(index);
            if (jEdit.getBooleanProperty((String)"buffertabs.closeButton", (boolean)true)) {
                this.setTabComponent(index, true);
            }
            if (component == this.textArea) {
                this.textArea.setVisible(true);
            }
        }
        finally {
            this.changeHandler.setEnabled(true);
        }
        if (this.editPane.getBuffer() == buffer) {
            this.setSelectedIndex(index);
            this.updateHighlightAt(index);
        } else {
            this.updateColorAt(index);
        }
    }

    private void setTabComponent(int index, boolean set) {
        try {
            Method m = this.getClass().getMethod("setTabComponentAt", Integer.TYPE, Component.class);
            if (m != null) {
                BufferTabComponent tab = set ? new BufferTabComponent(this) : null;
                m.invoke((Object)this, index, tab);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void bufferCleared() {
        this.changeHandler.setEnabled(false);
        this.knownBuffers.clear();
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.removeTabAt(i);
        }
        this.changeHandler.setEnabled(true);
    }

    public void bufferSetSorted() {
    }

    public void propertiesChanged() {
        if (ColorTabs.instance().isEnabled() != jEdit.getBooleanProperty((String)"buffertabs.color-tabs")) {
            ColorTabs.instance().setEnabled(!ColorTabs.instance().isEnabled());
            if (!ColorTabs.instance().isEnabled()) {
                for (int i = this.getTabCount() - 1; i >= 0; --i) {
                    this.setBackgroundAt(i, null);
                    this.setForegroundAt(i, null);
                }
                this.getUI().uninstallUI(this);
                UIManager.getDefaults().put("TabbedPane.selected", (Object)null);
                this.getUI().installUI(this);
            }
        }
        if (ColorTabs.instance().isEnabled()) {
            ColorTabs.instance().setMuteColors(jEdit.getBooleanProperty((String)"buffertabs.color-mute"));
            ColorTabs.instance().setColorVariation(jEdit.getBooleanProperty((String)"buffertabs.color-variation"));
            ColorTabs.instance().setForegroundColorized(jEdit.getBooleanProperty((String)"buffertabs.color-foreground"));
            if (ColorTabs.instance().isSelectedColorized() != jEdit.getBooleanProperty((String)"buffertabs.color-selected")) {
                ColorTabs.instance().setSelectedColorized(!ColorTabs.instance().isSelectedColorized());
                if (!ColorTabs.instance().isSelectedColorized()) {
                    try {
                        this.getUI().uninstallUI(this);
                        UIManager.getDefaults().put("TabbedPane.selected", (Object)null);
                        this.getUI().installUI(this);
                    }
                    catch (Exception e) {
                        Log.log((int)9, BufferTabs.class, (Object)("propertiesChanged: 3 " + e.toString()));
                    }
                }
            }
            if (ColorTabs.instance().isSelectedColorized()) {
                ColorTabs.instance().setSelectedForegroundColorized(jEdit.getBooleanProperty((String)"buffertabs.color-selected-foreground"));
            }
            ColorTabs.instance().propertiesChanged();
            int selectedIndex = this.getSelectedIndex();
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                if (selectedIndex == i) {
                    this.updateHighlightAt(i);
                    continue;
                }
                this.updateColorAt(i);
            }
        }
    }

    private void setBufferSet(BufferSet bufferSet) {
        if (bufferSet != this.bufferSet) {
            this.changeHandler.setEnabled(false);
            BufferSet oldBufferSet = this.bufferSet;
            if (oldBufferSet != null) {
                this.knownBuffers.clear();
                for (int i = this.getTabCount(); i > 0; --i) {
                    this.removeTabAt(0);
                }
            }
            this.bufferSet = bufferSet;
            this.changeHandler.setEnabled(true);
            bufferSet.getAllBuffers((BufferSetListener)this);
            if (oldBufferSet != null) {
                oldBufferSet.removeBufferSetListener((BufferSetListener)this);
            }
            bufferSet.addBufferSetListener((BufferSetListener)this);
        }
    }

    private void updateColorAt(int index) {
        if (!ColorTabs.instance().isEnabled()) {
            return;
        }
        if (index < 0) {
            return;
        }
        Buffer buffer = this.bufferSet.getBuffer(index);
        String name = buffer.getName();
        if (!ColorTabs.instance().isForegroundColorized()) {
            Color color = ColorTabs.instance().getDefaultColorFor(name);
            this.setBackgroundAt(index, color);
            this.setForegroundAt(index, null);
        } else {
            Color color = ColorTabs.instance().getDefaultColorFor(name);
            this.setForegroundAt(index, color);
            this.setBackgroundAt(index, null);
        }
    }

    private void updateHighlightAt(int index) {
        if (index < 0) {
            return;
        }
        if (ColorTabs.instance().isEnabled() && ColorTabs.instance().isSelectedColorized() && index == this.getSelectedIndex()) {
            Buffer buffer = this.bufferSet.getBuffer(index);
            String name = buffer.getName();
            Color color = ColorTabs.instance().getDefaultColorFor(name);
            if (!ColorTabs.instance().isSelectedForegroundColorized()) {
                Color selected = ColorTabs.instance().alterColorHighlight(color);
                this.setBackgroundAt(index, selected);
                this.setForegroundAt(index, null);
            } else {
                Color selected = ColorTabs.instance().alterColorDarken(color);
                this.setForegroundAt(index, selected);
                this.setBackgroundAt(index, null);
            }
        }
    }

    private void updateTitleAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        this.setTabComponent(index, jEdit.getBooleanProperty((String)"buffertabs.closeButton", (boolean)true));
        Buffer buffer = this.bufferSet.getBuffer(index);
        String title = buffer.getName();
        Icon icon = null;
        if (jEdit.getBooleanProperty((String)"buffertabs.icons", (boolean)true)) {
            icon = buffer.getIcon();
        } else {
            if (buffer.isDirty()) {
                title = title + "*";
            }
            if (buffer.isNewFile()) {
                title = title + " (new)";
            }
        }
        this.setTitleAt(index, title);
        this.setIconAt(index, icon);
    }

    public synchronized void updateTitles() {
        this.propertiesChanged();
        for (int index = this.getTabCount() - 1; index >= 0; --index) {
            this.updateTitleAt(index);
        }
    }

    public void setTabPlacement(String location) {
        location = location.toLowerCase();
        int placement = 3;
        if ("top".equals(location)) {
            placement = 1;
        } else if ("left".equals(location)) {
            placement = 2;
        } else if ("right".equals(location)) {
            placement = 4;
        }
        this.setTabPlacement(placement);
    }

    public Component getComponentAt(int index) {
        if (this.changeHandler.isEnabled() && index >= 0 && index < this.getTabCount()) {
            return this.textArea;
        }
        return super.getComponentAt(index);
    }

    public int indexOfComponent(Component component) {
        if (component instanceof BufferTabComponent) {
            return super.indexOfComponent(component);
        }
        return super.indexOfComponent(this.textArea);
    }

    protected String paramString() {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            return this.getTitleAt(index);
        }
        return "";
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return false;
    }

    public int getTabAt(int x, int y) {
        for (int index = 0; index < this.getTabCount(); ++index) {
            Rectangle rect = this.getBoundsAt(index);
            if (!rect.contains(x, y)) continue;
            return index;
        }
        return -1;
    }

    class MouseMotionHandler
    implements MouseMotionListener {
        MouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            if (moving != -1) {
                if (BufferTabs.this.getCursor() != Cursor.getPredefinedCursor(13)) {
                    BufferTabs.this.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                BufferTabs.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (GUIUtilities.isPopupTrigger((MouseEvent)e)) {
                if (!jEdit.getBooleanProperty((String)"buffertabs.usePopup", (boolean)true)) {
                    return;
                }
                BufferTabs.this.editPane.focusOnTextArea();
                JPopupMenu popupMenu = BufferTabsPlugin.getRightClickPopup();
                if (popupMenu == null) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                popupMenu.show(e.getComponent(), x, y);
            } else {
                if (SwingUtilities.isMiddleMouseButton(e) && jEdit.getBooleanProperty((String)"buffertabs.close-tab-on.single-middle-click")) {
                    int tabIndex = BufferTabs.this.getTabAt(e.getX(), e.getY());
                    BufferTabs.this.editPane.focusOnTextArea();
                    jEdit.closeBuffer((EditPane)BufferTabs.this.editPane, (Buffer)BufferTabs.this.bufferSet.getBuffer(tabIndex));
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    moving = BufferTabs.this.getTabAt(e.getX(), e.getY());
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && moving != -1) {
                int mv = moving;
                moving = -1;
                int index = BufferTabs.this.getTabAt(e.getX(), e.getY());
                if (index != -1 && index != mv) {
                    boolean movingEnabled = true;
                    if (BufferTabs.areBuffersSorted()) {
                        ReorderBuffersDisabledDialog dlg = new ReorderBuffersDisabledDialog((Frame)BufferTabs.this.editPane.getView());
                        dlg.setVisible(true);
                        boolean bl = movingEnabled = !BufferTabs.areBuffersSorted();
                    }
                    if (movingEnabled) {
                        jEdit.moveBuffer((EditPane)BufferTabs.this.editPane, (int)mv, (int)index);
                    }
                } else {
                    BufferTabs.this.editPane.focusOnTextArea();
                }
                BufferTabs.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && jEdit.getBooleanProperty((String)"buffertabs.close-tab-on.double-left-click")) {
                int tabIndex = BufferTabs.this.getTabAt(e.getX(), e.getY());
                BufferTabs.this.editPane.focusOnTextArea();
                jEdit.closeBuffer((EditPane)BufferTabs.this.editPane, (Buffer)BufferTabs.this.bufferSet.getBuffer(tabIndex));
            }
        }
    }

    class ReorderBuffersDisabledDialog
    extends JDialog {
        private static final String GEOMETRY = "buffertabs.reorderBuffersDisabledDialog.geometry";
        private JRadioButton disableSorting;
        private JRadioButton keepSorting;

        ReorderBuffersDisabledDialog(Frame frame) {
            super(frame, jEdit.getProperty((String)"buffertabs.reorderBuffersDisabled.label"), true);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ReorderBuffersDisabledDialog.this.saveGeometry();
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            JLabel message = new JLabel(jEdit.getProperty((String)"buffertabs.bufferTabPositioningDisabled.label"));
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 2;
            this.add((Component)message, c);
            this.disableSorting = new JRadioButton(jEdit.getProperty((String)"buffertabs.disableBufferSorting.label"), true);
            c.gridy += c.gridheight;
            c.gridheight = 1;
            this.add((Component)this.disableSorting, c);
            this.keepSorting = new JRadioButton(jEdit.getProperty((String)"buffertabs.keepBufferSorting.label"));
            ++c.gridy;
            this.add((Component)this.keepSorting, c);
            ButtonGroup options = new ButtonGroup();
            options.add(this.disableSorting);
            options.add(this.keepSorting);
            JButton close = new JButton("Close");
            close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReorderBuffersDisabledDialog.this.saveGeometry();
                    ReorderBuffersDisabledDialog.this.save();
                    ReorderBuffersDisabledDialog.this.setVisible(false);
                }
            });
            ++c.gridy;
            c.fill = 0;
            this.add((Component)close, c);
            this.pack();
            GUIUtilities.loadGeometry((Window)this, (String)GEOMETRY);
        }

        private void save() {
            if (this.disableSorting.isSelected()) {
                BufferTabs.stopBufferSorting();
            }
        }

        private void saveGeometry() {
            GUIUtilities.saveGeometry((Window)this, (String)GEOMETRY);
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private boolean enabled = true;

        private ChangeHandler() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public synchronized void stateChanged(ChangeEvent e) {
            Buffer buffer;
            int index = BufferTabs.this.getSelectedIndex();
            if (index >= 0 && this.isEnabled() && BufferTabs.this.bufferSet.size() > index && (buffer = BufferTabs.this.bufferSet.getBuffer(index)) != null) {
                int selectedIndex = BufferTabs.this.bufferSet.indexOf(BufferTabs.this.editPane.getBuffer());
                if (selectedIndex >= 0) {
                    BufferTabs.this.updateColorAt(selectedIndex);
                }
                BufferTabs.this.editPane.setBuffer(buffer);
                BufferTabs.this.updateHighlightAt(index);
            }
        }
    }
}

