/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import buffertabs.BufferTabs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.jEdit;

class BufferTabComponent
extends JPanel {
    private static CloseIcon icon = new CloseIcon();
    private static Dimension iconDimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
    private BufferTabs pane;

    BufferTabComponent(BufferTabs bufferTabs) {
        super(new FlowLayout(1, 5, 0));
        this.pane = bufferTabs;
        this.setOpaque(false);
        JLabel l = new JLabel(){

            public Icon getIcon() {
                int index = BufferTabComponent.this.pane.indexOfTabComponent(BufferTabComponent.this);
                if (index < 0) {
                    return null;
                }
                return BufferTabComponent.this.pane.getIconAt(index);
            }

            public String getText() {
                int index = BufferTabComponent.this.pane.indexOfTabComponent(BufferTabComponent.this);
                if (index < 0) {
                    return null;
                }
                return BufferTabComponent.this.pane.getTitleAt(index);
            }
        };
        this.add(l);
        final JLabel close = new JLabel(icon);
        close.setPreferredSize(iconDimension);
        close.setForeground(Color.BLACK);
        this.add(close);
        close.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                close.setForeground(Color.RED);
            }

            public void mouseExited(MouseEvent e) {
                close.setForeground(Color.BLACK);
            }

            public void mouseClicked(MouseEvent e) {
                int index = BufferTabComponent.this.pane.indexOfTabComponent(BufferTabComponent.this);
                if (index < 0) {
                    return;
                }
                jEdit.closeBuffer((EditPane)BufferTabComponent.this.pane.getEditPane(), (Buffer)((BufferTabComponent)BufferTabComponent.this).pane.bufferSet.getBuffer(index));
            }
        });
    }

    private static class CloseIcon
    implements Icon {
        private static final int width = 9;
        private static final int height = 11;
        private static final int top = 3;

        private CloseIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(0, 3, 7, 10);
            g.drawLine(1, 3, 8, 10);
            g.drawLine(8, 3, 1, 10);
            g.drawLine(7, 3, 0, 10);
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 11;
        }
    }
}

