package org.renpy.android;

import org.libsdl.app.SDLActivity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Vibrator;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Toast;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

import org.renpy.iap.Store;

public class PythonSDLActivity extends SDLActivity {

	/**
	 * This exists so python code can access this activity.
	 */
	public static PythonSDLActivity mActivity = null;

	/**
	 * The layout that contains the SDL view. VideoPlayer uses this to add
	 * its own view on on top of the SDL view.
	 */
	public FrameLayout mFrameLayout;


	/**
	 * A layout that contains mLayout. This is a 3x3 grid, with the layout
	 * in the center. The idea is that if someone wants to show an ad, they
	 * can stick it in one of the other cells..
	 */
	public LinearLayout mVbox;

	ResourceManager resourceManager;

	// GUI code. /////////////////////////////////////////////////////////////


	public void addView(View view, int index) {
		mVbox.addView(view, index, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT, (float) 0.0));
	}

	public void removeView(View view) {
		mVbox.removeView(view);
	}

	@Override
	public void setContentView(View view) {
		mFrameLayout = new FrameLayout(this);
		mFrameLayout.addView(view);

		mVbox = new LinearLayout(this);
		mVbox.setOrientation(LinearLayout.VERTICAL);
		mVbox.addView(mFrameLayout, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, 0, (float) 1.0));

		super.setContentView(mVbox);
	}

	// Code to unpack python and get things running ///////////////////////////

    public void recursiveDelete(File f) {
        if (f.isDirectory()) {
            for (File r : f.listFiles()) {
                recursiveDelete(r);
            }
        }
        f.delete();
    }

    /**
     * This determines if unpacking one the zip files included in
     * the .apk is necessary. If it is, the zip file is unpacked.
     */
    public void unpackData(final String resource, File target) {

    	/**
    	 * Delete main.pyo unconditionally. This fixes a problem where we have
    	 * a main.py newer than main.pyo, but start.c won't run it.
    	 */
    	new File(target, "main.pyo").delete();

        // The version of data in memory and on disk.
        String data_version = resourceManager.getString(resource + "_version");
        String disk_version = null;

        // If no version, no unpacking is necessary.
        if (data_version == null) {
            return;
        }

        // Check the current disk version, if any.
        String filesDir = target.getAbsolutePath();
        String disk_version_fn = filesDir + "/" + resource + ".version";

        try {
            byte buf[] = new byte[64];
            InputStream is = new FileInputStream(disk_version_fn);
            int len = is.read(buf);
            disk_version = new String(buf, 0, len);
            is.close();
        } catch (Exception e) {
            disk_version = "";
        }

        // If the disk data is out of date, extract it and write the
        // version file.
        if (! data_version.equals(disk_version)) {
            Log.v("python", "Extracting " + resource + " assets.");

            // Delete old libraries & renpy files.
            recursiveDelete(new File(target, "lib"));
            recursiveDelete(new File(target, "renpy"));

            target.mkdirs();

            AssetExtract ae = new AssetExtract(this);
            if (!ae.extractTar(resource + ".mp3", target.getAbsolutePath())) {
                toastError("Could not extract " + resource + " data.");
            }

            try {
                // Write .nomedia.
                new File(target, ".nomedia").createNewFile();

                // Write version file.
                FileOutputStream os = new FileOutputStream(disk_version_fn);
                os.write(data_version.getBytes());
                os.close();
            } catch (Exception e) {
                Log.w("python", e);
            }
        }

    }

    /**
     * Show an error using a toast. (Only makes sense from non-UI
     * threads.)
     */
    public void toastError(final String msg) {

        final Activity thisActivity = this;

        runOnUiThread(new Runnable () {
            public void run() {
                Toast.makeText(thisActivity, msg, Toast.LENGTH_LONG).show();
            }
        });

        // Wait to show the error.
        synchronized (this) {
            try {
                this.wait(1000);
            } catch (InterruptedException e) {
            }
        }
    }

	public native void nativeSetEnv(String variable, String value);

    public void preparePython() {
    	Log.v("python", "Starting preparePython.");

    	mActivity = this;

    	resourceManager = new ResourceManager(this);

        File oldExternalStorage = new File(Environment.getExternalStorageDirectory(), getPackageName());
        File externalStorage = getExternalFilesDir(null);
        File path;

        if (externalStorage == null) {
        	externalStorage = oldExternalStorage;
        }

        if (resourceManager.getString("public_version") != null) {
            path = externalStorage;
        } else {
        	path = getFilesDir();
        }

        unpackData("private", getFilesDir());
        unpackData("public", externalStorage);

    	nativeSetEnv("ANDROID_ARGUMENT", path.getAbsolutePath());
		nativeSetEnv("ANDROID_PRIVATE", getFilesDir().getAbsolutePath());
    	nativeSetEnv("ANDROID_PUBLIC",  externalStorage.getAbsolutePath());
    	nativeSetEnv("ANDROID_OLD_PUBLIC", oldExternalStorage.getAbsolutePath());

    	// Figure out the APK path.
        String apkFilePath;
        ApplicationInfo appInfo;
        PackageManager packMgmr = getApplication().getPackageManager();

        try {
            appInfo = packMgmr.getApplicationInfo(getPackageName(), 0);
            apkFilePath = appInfo.sourceDir;
        } catch (NameNotFoundException e) {
            apkFilePath = "";
        }

    	nativeSetEnv("ANDROID_APK", apkFilePath);

    	String expansionFile = getIntent().getStringExtra("expansionFile");

    	if (expansionFile != null) {
    		nativeSetEnv("ANDROID_EXPANSION", expansionFile);
    	}

    	nativeSetEnv("PYTHONOPTIMIZE", "2");
    	nativeSetEnv("PYTHONHOME", getFilesDir().getAbsolutePath());
    	nativeSetEnv("PYTHONPATH", path.getAbsolutePath() + ":" + getFilesDir().getAbsolutePath() + "/lib");

        Log.v("python", "Finished preparePython.");

    };

    // Code to support devicePurchase. /////////////////////////////////////////

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Store.create(this);
    }

    @Override
    protected void onDestroy() {
    	super.onDestroy();
    	Store.getStore().destroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
    	if (Store.getStore().onActivityResult(requestCode, resultCode, intent)) {
    	    return;
        }

    	super.onActivityResult(requestCode, resultCode, intent);
    }

    // Code to support public APIs. ////////////////////////////////////////////

    public void openUrl(String url) {
        Log.i("python", "Opening URL: " + url);

        Intent i = new Intent(Intent.ACTION_VIEW);
        i.setData(Uri.parse(url));
        startActivity(i);
    }

    public void vibrate(double s) {
        Vibrator v = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        if (v != null) {
            v.vibrate((int) (1000 * s));
        }
    }

    public int getDPI() {
    	DisplayMetrics metrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(metrics);
    	return metrics.densityDpi;
    }

    public PowerManager.WakeLock wakeLock = null;

    public void setWakeLock(boolean active) {
    	if (wakeLock == null) {
			PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
			wakeLock = pm.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK, "Screen On");
			wakeLock.setReferenceCounted(false);
    	}

    	if (active) {
    		wakeLock.acquire();
    	} else {
    		wakeLock.release();
    	}
    }

}
