/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import java.util.Random;
import tv.ouya.console.internal.util.CurrentTime;

public class SerialNumber {
    public static final String SERIAL_PREFS = "serial_prefs";
    public static final String SERIAL = "serial";
    private static SerialNumber instance;
    private CurrentTime currentTime;
    private String serialNumber;
    private Context context;

    public static SerialNumber getInstance(Context context) {
        if (instance == null) {
            instance = new SerialNumber(context);
        }
        return instance;
    }

    @Deprecated
    public static void setInstance(SerialNumber instance) {
        SerialNumber.instance = instance;
    }

    @Deprecated
    public SerialNumber(Context context) {
        this.context = context;
        this.currentTime = CurrentTime.getInstance();
    }

    private void firstTime() {
        if (!Build.SERIAL.startsWith("emulator") && !Build.SERIAL.equals("unknown")) {
            this.serialNumber = Build.SERIAL;
            return;
        }
        Context packageContext = null;
        try {
            packageContext = this.context.createPackageContext("tv.ouya", 2);
            if (packageContext == null) {
                packageContext = this.context;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.serialNumber = packageContext.getSharedPreferences(SERIAL_PREFS, 3).getString(SERIAL, null);
        if (this.serialNumber == null) {
            this.serialNumber = this.generateSerialNumber(packageContext);
        }
    }

    public String getSerialNumber() {
        if (this.serialNumber == null) {
            this.firstTime();
        }
        return this.serialNumber;
    }

    private String generateSerialNumber(Context context) {
        String serial = "" + Long.valueOf(new Random(this.currentTime.currentTimeMillis()).nextLong()).hashCode();
        SharedPreferences prefs = context.getSharedPreferences(SERIAL_PREFS, 3);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(SERIAL, serial);
        editor.commit();
        return serial;
    }
}

