#!/usr/bin/env python


# Copyright 2004-2006 PyTom <pytom@bishoujo.us>
# 
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# 
#!/usr/bin/env python

# This program dumps all the text found in the script to stdout.

import codecs
import sys
import os
import re
import glob

import renpy
renpy.import_all()

def process_block(block, out):

    for fn, ln, text, child in block:

        if text.startswith("$") or text.startswith("python"):
            continue

        if text.startswith("init"):
            continue

        if text.startswith("if") or text.startswith("while"):
            process_block(child, out)
            continue

        for m in re.finditer(r'"((?:[^\\"]+|\\.)+)"|' +
                             r"'((?:[^\\']+|\\.)+)'", text):

            s = m.group(1) or m.group(2)

            s = re.sub(r'\s+', ' ', s)
            s = re.sub(r'\\.', ' ', s)

            s = re.sub(r'\{.*?\}', '', s)

            print >>out, s.encode('utf-8')
            print >>out

        process_block(child, out)
        

def process(fn, out):

    block = renpy.parser.group_logical_lines(renpy.parser.list_logical_lines(fn))

    process_block(block, out)


def main():

    pattern = "game/*.rpy"

    if len(sys.argv) >= 2:
        pattern = sys.argv[1]

    files = glob.glob(pattern)
    files = [ i for i in files if not i.startswith("common/") ]

    out = sys.stdout
    out.write(codecs.BOM_UTF8)

    for fn in files:
        process(fn, out)

    out.close()


if __name__ == "__main__":
    main()
