#!/usr/bin/env python


# Copyright 2004-2006 PyTom <pytom@bishoujo.us>
# 
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# 
#!/usr/bin/env python

# The Ren'Py archiver. This builds a Ren'Py archive file, and the
# associated index file. These files are really easy to reverse-engineer,
# but are probably better than nothing.

import sys
import os
import encodings.zlib_codec
import random
import glob

from pickle import loads, dumps, HIGHEST_PROTOCOL

# The amount of padding we will add.
padding_max = 64

def randpadding():

    plen = random.randint(1, padding_max)

    rv = ""

    for i in range(0, plen):
        rv += chr(random.randint(1, 255))

    return rv

def main():
    if len(sys.argv) < 3:
        print "Usage: %s <file-prefix> <files ...>" % sys.argv[0]
        return

    prefix = sys.argv[1]

    # Archive file.
    archivef = file(prefix + ".rpa", "wb")

    # Index file.
    # indexf = file(prefix + ".rpi", "wb")

    index = { }

    random.seed()

    
    padding = "RPA-2.0 XXXXXXXXXXXXXXXX direct\n"

    archivef.write(padding)
    offset = len(padding)

    # Needed because windows sucks. It doesn't do globbing on the
    # command line.
    files = [ ]
    for i in sys.argv[2:]:
        files.extend(glob.glob(i))

    for fn in files:
        index[fn] = [ ]

        print "Adding %s..." % fn

        datafile = file(fn, "rb")

        while True:

            # Pad with junk.
            padding = randpadding()
            archivef.write(padding)
            offset += len(padding)

            data = datafile.read()

            if not data:
                break

            dlen = len(data)

            archivef.write(data)

            index[fn].append((offset, dlen))
            offset += dlen
                      
        datafile.close()

    indexoff = offset

    archivef.write(dumps(index, HIGHEST_PROTOCOL).encode("zlib"))

    archivef.seek(0)
    archivef.write("RPA-2.0 %016x\n" % indexoff)


    archivef.close()
    
    

if __name__ == "__main__":
    main()
